## menu

#### Description

The menu plugin type allows the user to add a new menu command to the Plugins menu in the main application menubar.  All menu plugins can optionally append any number of “.submenu” items to the menubar menu representing a cascading menu hierarchy within the menu that the command will be placed in.  This allows the user to organize plugin menu items into groups, making the menu easier to find commands and easier to read/understand.

#### Tcl Registration

```Tcl
{menu command hierarchy do_procname handle_state_procname}
{menu {checkbutton variable} hierarchy do_procname handle_state_procname}
{menu {radiobutton variable value} hierarchy do_procname handle_state_procname}
{menu separator hierarchy}
```

The “menu command” type creates a menu command that, when clicked, runs the procedure called _do\_procname_.  The _hierarchy_ value specifies the menu hierarchy (optional) and string text in the menu (joined with periods).  The hierarchy will be created if it does not exist.

The “menu checkbutton” type creates a menu command has an on/off state associated with it.  When the menu item is clicked, the state of the menu item is inverted and the _do\_procname_ procedure is called.  The _variable_ argument is the name of a variable containing the current on/off value associated with the menu item.  The _hierarchy_ value specifies the menu hierarchy (optional) and string text in the menu (joined with periods).  The hierarchy will be created if it does not exist.

The “menu radiobutton” type creates a menu command that has an on/off state such that in a group of multiple menu items that share the same variable, only one is on at at time.  When the menu item is clicked, the state of the menu item is set to on and the _do\_procname_ procedure is called.  The _variable_ argument is the name of a variable containing the menu item that is currently on.  The _value_ value specifies a unique identifier for this menu within the group.  When the value of variable is set to value, this menu option will have the on state.  The _hierarchy_ value specifies the menu hierarchy (optional) and string text in the menu (joined with periods).  The hierarchy will be created if it does not exist.

The “menu separator” type creates a horizontal separator in the menu which is useful for organizing menu options.  The _hierarchy_ value, in this case, only refers to the menu hierarchy to add the separator to (menu separators don’t have text associated with them).

#### Tcl Procedures

**The “do” Procedure**

The "do" procedure contains the code that will be executed when the user invokes the menu item in the menubar.
 
Example:

```Tcl
proc foobar_menubar_do {} {
  puts "Foobar menu item has been clicked!"
}
```

** The “handle\_state” Procedure**

The "handle\_state" procedure is called when the Plugin menu is created (when the "Plugins" menubar item is clicked).  This procedure is responsible for determining the state of the menu item to normal (1) or disabled (0) as deemed appropriate by the plugin creator.

Example:

```Tcl
proc foobar_menubar_handle_state {} {
  return $some_test_condition
}
```
